 
// #4X 2010 Bid Ask           \/
// Knowledge of the ancients ( )
//______________________o0o___(_)___o0o_____
//___Xard777_____________________2010_

#property indicator_chart_window


  extern string note1 = "Change font colors automatically? True = Yes";
  extern bool   Bid_Ask_Colors = True;
  extern bool   ShowBid = true;
  extern bool   ShowAsk = false;
  extern bool   show.countdown = false;
  extern bool   show.info = False;
  extern int    CD = 25;
  extern bool   show.timer = true;
  extern color  DefaultColor = White;
  extern color  BidUpColor = Lime;
  extern color  BidDnColor = Red;
  extern color  AskUpColor = Lime;
  extern color  AskDnColor = Red;
  extern string note3 = "Font Size";
  extern int    BidFontSize=32;
  extern int    AskFontSize=22;
  extern string note4 = "Font Type";
  extern string BidFontType="Arial";
  extern string AskFontType="Arial";
  extern string note5 = "Display the price in what corner?";
  extern string note6 = "Upper left=0; Upper right=1";
  extern string note7 = "Lower left=2; Lower right=3";
  extern int    WhatCorner=3;
  extern string note8 = "Display the price in what window?";
  extern int    WhatWindow=1;
  extern int    WhatWindow1=1;
  extern int    WhatWindow2=1;
   
  double        Old_Ask_Price, Old_Bid_Price, DecNos, gi_88;

int init()
   {
   return(0);
   }

int deinit()
   {
   ObjectDelete("Market_Ask_Price_Label");
   ObjectDelete("Market_Bid_Price_Label");
   
   ObjectsDeleteAll(WhatWindow,OBJ_LABEL);
   ObjectsDeleteAll(WhatWindow1,OBJ_LABEL);
   ObjectsDeleteAll(WhatWindow2,OBJ_LABEL);  
   return(0);
   }

int start()
   {
   
   if (show.timer == True)
   {
   int li_8 = Time[0] + 60 * Period() - TimeCurrent();
   double ld_0 = li_8 / 60.0;
   int li_12 = li_8 % 60;
   li_8 = (li_8 - li_8 % 60) / 60;
   
   ObjectDelete("tm");
   ObjectCreate("tm", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("tm", "Bar  " + li_8 + ":" + li_12, 15, "Arial", MediumVioletRed);
   ObjectSet("tm", OBJPROP_CORNER, 3);
   ObjectSet("tm", OBJPROP_BACK, false);
   ObjectSet("tm", OBJPROP_XDISTANCE, 5);
   ObjectSet("tm", OBJPROP_YDISTANCE, 32);
   }
   
   if (StringFind (Symbol(), "JPY", 0) != -1){ DecNos = 2;}
   else { DecNos = 4; }
   
   int    counted_bars=IndicatorCounted();
   
   int AskYoffset, BidYoffset;
   color AskColor, BidColor;
   
   if (Bid_Ask_Colors == True)
      {
      if (Ask > Old_Ask_Price) AskColor = AskUpColor;
      if (Ask < Old_Ask_Price) AskColor = AskDnColor;
      if (Ask == Old_Ask_Price) AskColor = DefaultColor;
      if (Bid > Old_Bid_Price) BidColor = BidUpColor;
      if (Bid < Old_Bid_Price) BidColor = BidDnColor;
      if (Bid == Old_Bid_Price) BidColor = DefaultColor;
      Old_Ask_Price = Ask;
      Old_Bid_Price = Bid;
      }
    
   if (Bid_Ask_Colors == False)
      {
      if (Ask > Old_Ask_Price) AskColor = DefaultColor;
      if (Ask < Old_Ask_Price) AskColor = DefaultColor;
      if (Ask == Old_Ask_Price) AskColor = DefaultColor;
      if (Bid > Old_Bid_Price) BidColor = DefaultColor;
      if (Bid < Old_Bid_Price) BidColor = DefaultColor;
      if (Bid == Old_Bid_Price) BidColor = DefaultColor;
      Old_Ask_Price = Ask;
      Old_Bid_Price = Bid;
      }
    
   
   string Market_Ask_Price = DoubleToStr(Ask, DecNos);
   string Market_Bid_Price = DoubleToStr(Bid, DecNos);
   
   if(ShowBid == True && ShowAsk  == True)
      {
      if(WhatCorner == 2 || WhatCorner == 3)
         {
         AskYoffset = BidFontSize + 8;
         BidYoffset = 1;
         }
      if(WhatCorner == 0 || WhatCorner == 1)
         {
         AskYoffset = 1;
         BidYoffset = AskFontSize + 8;
         }

      ObjectCreate("Market_Ask_Price_Label", OBJ_LABEL, WhatWindow, 0, 0);
      ObjectSetText("Market_Ask_Price_Label", Market_Ask_Price, AskFontSize, AskFontType, AskColor);
      ObjectSet("Market_Ask_Price_Label", OBJPROP_CORNER, WhatCorner);
      ObjectSet("Market_Ask_Price_Label", OBJPROP_XDISTANCE, 5);
      ObjectSet("Market_Ask_Price_Label", OBJPROP_YDISTANCE, AskYoffset);
   
      
      ObjectCreate("Market_Bid_Price_Label", OBJ_LABEL, WhatWindow, 0, 0);
      ObjectSetText("Market_Bid_Price_Label", Market_Bid_Price, BidFontSize, BidFontType, BidColor);
      ObjectSet("Market_Bid_Price_Label", OBJPROP_CORNER, WhatCorner);
      ObjectSet("Market_Bid_Price_Label", OBJPROP_XDISTANCE, 5);
      ObjectSet("Market_Bid_Price_Label", OBJPROP_YDISTANCE, 50);
       
      }
      
   if(ShowBid == True && ShowAsk == False)
      {
      BidYoffset = 1;
      
      ObjectCreate("Market_Bid_Price_Label", OBJ_LABEL, WhatWindow, 0, 0);
      ObjectSetText("Market_Bid_Price_Label", Market_Bid_Price, BidFontSize, BidFontType, BidColor);
      ObjectSet("Market_Bid_Price_Label", OBJPROP_CORNER, WhatCorner);
      ObjectSet("Market_Bid_Price_Label", OBJPROP_XDISTANCE, 5);
      ObjectSet("Market_Bid_Price_Label", OBJPROP_YDISTANCE, 50);
      }
      
   if(ShowBid == False && ShowAsk == True)
      {
      AskYoffset = 1;
      
      ObjectCreate("Market_Ask_Price_Label", OBJ_LABEL, WhatWindow, 0, 0);
      ObjectSetText("Market_Ask_Price_Label", Market_Ask_Price, AskFontSize, AskFontType, AskColor);
      ObjectSet("Market_Ask_Price_Label", OBJPROP_CORNER, WhatCorner);
      ObjectSet("Market_Ask_Price_Label", OBJPROP_XDISTANCE, 5);
      ObjectSet("Market_Ask_Price_Label", OBJPROP_YDISTANCE, AskYoffset);
      } 
      
      ObjectDelete("x2b");
      ObjectCreate("x2b", OBJ_LABEL, WhatWindow, 0, 0);
      ObjectSetText("x2b",Symbol() , 23, "Arial Bold", White);
      ObjectSet("x2b", OBJPROP_CORNER, 3);
      ObjectSet("x2b", OBJPROP_BACK, 0);
      ObjectSet("x2b", OBJPROP_XDISTANCE, 1);
      ObjectSet("x2b", OBJPROP_YDISTANCE,  1);

  //}

   if(show.countdown == True)
      {
      ObjectDelete("CD");
      ObjectCreate("CD", OBJ_LABEL, WhatWindow2, 0, 0);
      ObjectSetText("CD", "t-"+DoubleToStr(CD,0), 25, "Arial Bold", C'0,50,130');
      ObjectSet("CD", OBJPROP_CORNER, 3);
      ObjectSet("CD", OBJPROP_BACK, True);
      ObjectSet("CD", OBJPROP_XDISTANCE, 5);
      ObjectSet("CD", OBJPROP_YDISTANCE, 1);
      }
        
ObjectDelete("BPS");
   ObjectCreate("BPS", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("BPS", Alive(), 15, "Arial Bold", White);
   ObjectSet("BPS", OBJPROP_CORNER, 2);
   ObjectSet("BPS", OBJPROP_BACK, false);
   ObjectSet("BPS", OBJPROP_XDISTANCE, 14);
   ObjectSet("BPS", OBJPROP_YDISTANCE, 1);
  
   if(show.info == True)
   {
   ObjectDelete("Spread");
   ObjectCreate("Spread", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Spread", "Day High: " +DoubleToStr(iHigh(NULL, PERIOD_D1, 0), DecNos), 14, "Arial", White);
   ObjectSet("Spread", OBJPROP_CORNER, 2);
   ObjectSet("Spread", OBJPROP_BACK, false);
   ObjectSet("Spread", OBJPROP_XDISTANCE, 40);
   ObjectSet("Spread", OBJPROP_YDISTANCE, 5);
   
   ObjectDelete("Spread2");
   ObjectCreate("Spread2", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Spread2", "Day Low: " + DoubleToStr(iLow(NULL, PERIOD_D1, 0), DecNos) + "   Day H-L:  " + DoubleToStr((iHigh(NULL, PERIOD_D1, 0) - iLow(NULL, PERIOD_D1, 0)) / Point/10, 0), 14, "Arial", White);
   ObjectSet("Spread2", OBJPROP_CORNER, 2);
   ObjectSet("Spread2", OBJPROP_BACK, false);
   ObjectSet("Spread2", OBJPROP_XDISTANCE, 195);
   ObjectSet("Spread2", OBJPROP_YDISTANCE, 5);
   
   ObjectDelete("Spread3");
   ObjectCreate("Spread3", OBJ_LABEL, WhatWindow1, 0, 0);
   ObjectSetText("Spread3", "Prev Day H-L: " + DoubleToStr((iHigh(NULL, PERIOD_D1, 1) - iLow(NULL, PERIOD_D1, 1)) / Point/10, 0), 14, "Arial", White);
   ObjectSet("Spread3", OBJPROP_CORNER, 2);
   ObjectSet("Spread3", OBJPROP_BACK, false);
   ObjectSet("Spread3", OBJPROP_XDISTANCE, 475);
   ObjectSet("Spread3", OBJPROP_YDISTANCE, 5);
   
   ObjectDelete("Spread4");
   ObjectCreate("Spread4", OBJ_LABEL, WhatWindow, 0, 0);
   ObjectSetText("Spread4", "Projected High:  " + DoubleToStr(2.0 * iHigh(NULL, PERIOD_D1, 1) - iLow(NULL, PERIOD_D1, 1), DecNos) + "   Low: " + DoubleToStr(2.0 * iLow(NULL, PERIOD_D1, 1) - iHigh(NULL, PERIOD_D1, 1), DecNos), 14, "Arial", MediumVioletRed);
   ObjectSet("Spread4", OBJPROP_CORNER, 0);
   ObjectSet("Spread4", OBJPROP_BACK, false);
   ObjectSet("Spread4", OBJPROP_XDISTANCE, 40);
   ObjectSet("Spread4", OBJPROP_YDISTANCE, 15);
   }  
 }
 

   string Alive() {
   string ls_ret_0;
   
   gi_88++;
   if (gi_88 > 9) gi_88 = 1;
   if (gi_88 == 1) ls_ret_0 = "X";
   if (gi_88 == 2) ls_ret_0 = "A";
   if (gi_88 == 3) ls_ret_0 = "R";
   if (gi_88 == 4) ls_ret_0 = "D";
   if (gi_88 == 5) ls_ret_0 = "A";
   if (gi_88 == 6) ls_ret_0 = "L";
   if (gi_88 == 7) ls_ret_0 = "I";
   if (gi_88 == 8) ls_ret_0 = "V";
   if (gi_88 == 9) ls_ret_0 = "E";
   return (ls_ret_0);
//----
   return(0);
  }
//+--  